<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddImageIdToArticles extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::table('articles',function(Blueprint $table) {
			$table->integer('image_id')->unsigned()->nullable()->after('story_id');
			$table->foreign('image_id')->references('id')->on('media')->onDelete('cascade');
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::table('articles',function(Blueprint $table) {
			$table->dropForeign('articles_image_id_foreign');
			$table->dropColumn('image_id');
		});
	}

}
