@extends($layout)

@section('content')
	<section id='articles'>
		<h1>News</h1>
		@include('articles::partials.archive-list')

		@if($articles->count() === 0) {
			
			<p>No articles to show.</p>

		@else

			@if ($articles->currentPage() === 1)
			
				{{-- Show first two articles prominently at the top --}}
				<div class='featured-articles'>
				@include('articles::partials.articles-list',['articles' => $articles->slice(0, 2)])
				</div>

				@if($story)

					@include('articles::partials.story-featured',['story' => $story])
					
				@endif

			@endif

			{{-- Show remaining articles below in list --}}

			@if ($articles->currentPage() === 1)

				@include('articles::partials.articles-list',['articles' => $articles->slice(2),'title' => 'More News'])

			@else

				@include('articles::partials.articles-list',['articles' => $articles])

			@endif

			@include('articles::partials.find-articles-about')

			{!! $articles->render() !!}

		@endif

	</section>
@stop