@include('articles::partials.article-meta')
@include('partials.share')

@if($article->story)

<div class='part-of-story'>
	<h3>Follow the story:</h3>
	<h2>{{ $article->story->name }}</h2>
	<ol>
		@foreach($article->story->articles as $story_article)
		<li class='{{ $article->id == $story_article->id ? "active" : "" }}'>
			<a href='{{ $story_article->getUrl() }}'>
				<strong>{{ $story_article->name }}</strong>
				{{ $story_article->date->format('jS F Y ') }}
			</a>
		</li>
		@endforeach
	</ol>
</div>

@else

<h2>You may also like</h2>

<div class='related-articles'>
	<ol>
		@foreach($related as $related_article)
		<li>
			<a href='{{ $related_article->getUrl() }}'>
				<strong>{{ $related_article->name }}</strong>
				{{ $related_article->date->format('jS F Y ') }}
			</a>
		</li>
		@endforeach
	</ol>
</div>

@endif