<?php namespace Concore\Articles\Http\Controllers;

use Concore\Tags\Models\Tag;
use Carbon\Carbon;
use Redirect;
use Concore\Articles\Services\ArticlesService;

class ArticleController extends \Illuminate\Routing\Controller {

	public function index(ArticlesService $articles_service) {
		$articles = $articles_service->getLatest();
		$story = $articles_service->getFeaturedStory();
		return view('articles::index')->with(compact('articles','story'));
	}

	public function show(ArticlesService $articles_service, $key) {
		$this->article = $articles_service->getByKey($key);
		if(!$this->article) {
			return abort(404);
		}

		$related = null;
		if(!$this->article->story) {
			$related = $articles_service->getRelated($this->article, 3);
		}
		
		return view('articles::show')->with('article',$this->article)->with('related',$related);
	}

	public function archive(ArticlesService $articles_service, Carbon $carbon, $year_month) {
		$articles = $articles_service->getArchive($year_month);
		$date = Carbon::createFromTimestamp(strtotime($year_month));
		return view('articles::archive')->with(compact('articles','date'));
	}

	public function byTag(ArticlesService $articles_service, Tag $tag, $tag_key) {
		$tag = $tag->where('key','=',$tag_key)->first();
		if(!$tag) {
			return abort(404);
		}
		$articles = $articles_service->findWithTag($tag->key);
		if(!$articles->count()) {
			return Redirect::route('articles');
		}
		return view('articles::by-tag')->with(compact('articles','tag'));
	}
}
