<?php namespace Concore\Articles\Http\ViewComposers;

use Illuminate\Contracts\View\View;
use Concore\Articles\Services\ArticlesService;

class ArchiveListComposer {

    private $article_service;

    public function __construct(ArticlesService $article_service) {
        $this->article_service = $article_service;
    }

    /**
     * Bind data to the view.
     *
     * @param  View  $view
     * @return void
     */
    public function compose(View $view)
    {
        $archive_list = $this->article_service->getArchiveList();

        $parameters = \Route::current()->parameters();
        if(isset($parameters['year_month'])) {
            $archive_current = route('articles.archive',$parameters['year_month']);
            $archive_current_index = array_search($archive_current, array_values($archive_list)) + 1;
        } else {
            $archive_current_index = 0;
        }

        $view->with(compact('archive_list','archive_current_index'));
    }

}