<?php

/*
|--------------------------------------------------------------------------
| Package Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for a package.
| It's a breeze. Simply tell Laravel the URIs it should respond to
| and give it the controller to call when that URI is requested.
|
*/

Route::group(['namespace' => 'Concore\Articles\Http\Controllers'],function() {
	Route::get('/news',['as' => 'articles','uses' => 'ArticleController@index']);
	Route::get('/news/{year_month}',['as' => 'articles.archive','uses' => 'ArticleController@archive'])
		   ->where('year_month','[0-9]{4}\-[0-9]{2}');
	Route::get('/news/tagged/{tag}',['as' => 'articles.by-tag','uses' => 'ArticleController@byTag'])
		   ->where('tag','[a-z0-9\-]+');
	Route::get('/news/{key}',['as' => 'article','uses' => 'ArticleController@show']);
});