<?php namespace Concore\Articles\Models;

use Concore\Foundation\Models\Traits\IdentifiableTrait;
use Concore\Foundation\Models\Traits\HasKeyTrait;
use Concore\Tags\Models\Traits\HasTagsTrait;
use Concore\Foundation\Models\Interfaces\IdentifiableInterface;

class Article extends \Illuminate\Database\Eloquent\Model implements IdentifiableInterface {

	use IdentifiableTrait,
		HasKeyTrait,
		HasTagsTrait;

	public $dates = ['date'];
    public $relation_methods = ['meta','tags','story','image'];
	protected $touches = ['story'];
	protected $fillable = ['name','key','date','intro','body','story_id','image_id'];

	public function story() {
		return $this->belongsTo(app('Concore\Articles\Models\Story'));
	}

	public function related() {
		return $this->belongsToMany(new self(), null, 'article_id', 'related_article_id');
	}

	public function scopeOrderByDate($query, $direction = 'desc') {
		return $query->orderBy('date',$direction);
	}

	public function image() {
		return $this->belongsTo(app('Concore\Foundation\Models\Media'));
	}

}
