<?php namespace Concore\Articles\Models;

use Carbon\Carbon;
use Concore\Foundation\Models\Traits\IdentifiableTrait;
use Concore\Foundation\Models\Traits\HasKeyTrait;
use Concore\Foundation\Models\Interfaces\IdentifiableInterface;

class Story extends \Illuminate\Database\Eloquent\Model implements IdentifiableInterface {
	
	use IdentifiableTrait,
		HasKeyTrait;

	protected $fillable = ['key','name','description'];

	protected $relations_methods = ['articles'];

	public function articles() {
		return $this->hasMany(app('Concore\Articles\Models\Article'))->orderByDate('asc');
	}

	public function scopeRecentlyUpdated($query) {
		$query->whereHas('articles',function($articles) {
			$cutoff = Carbon::createFromTimestamp(strtotime('-2 weeks'));
			$articles->where('date','>=',$cutoff->format('y-m-d'));
		});
	}

}
