<?php namespace Concore\Articles\Providers;

use View;
use Illuminate\Support\ServiceProvider;
use Concore\Foundation\Providers\Traits\ExplicitViewLoaderTrait;

class ArticlesServiceProvider extends ServiceProvider {

	use ExplicitViewLoaderTrait;

	/**
	 * Indicates if loading of the provider is deferred.
	 *
	 * @var bool
	 */
	protected $defer = false;

	/**
	 * Register the service provider.
	 *
	 * @return void
	 */
	public function register()
	{
		$this->routes();
	}

	/**
	 * Load utility functions, custom exceptions, view composers, form macros, custom validators.
	 * Register facades, service providers and aliases.
	 *
	 * @return void
	 */
	public function boot()
	{

		$this->composers();

		$this->loadViewsFrom(__DIR__.'/../../resources/views/', 'articles');

		// Publishes

		$this->publishes([
	        __DIR__.'/../../resources/views/' => base_path('resources/views/vendor/articles'),
	    ], 'views');
	    $this->publishes([
		    __DIR__.'/../../migrations/' => $this->app->databasePath() . '/migrations'
		], 'migrations');

		// This binding allows the models to be used in sculpt
		$this->app->bind('sculpt-model.article','Concore\Articles\Models\Article');
        $this->app->tag('sculpt-model.article','sculpt-models');
		$this->app->bind('sculpt-model.story','Concore\Articles\Models\Story');
        $this->app->tag('sculpt-model.story','sculpt-models');
	}

	/**
	 * Get the services provided by the provider.
	 *
	 * @return array
	 */
	public function provides()
	{
		return array();
	}

	public function routes() {
		include __DIR__.'/../Http/routes.php';
	}

	private function composers() 
	{
		View::composer('articles::partials.archive-list', 'Concore\Articles\Http\ViewComposers\ArchiveListComposer');
	}

}
