<?php namespace Concore\Auditing\Models;

use View, Config;
use Illuminate\Database\Eloquent\Model;

class AuditLog extends Model {

    public $timestamps = false;

	protected $guarded = ['id'];
    protected $dates = ['created_at'];

    public function __toString() {
        $view = 'auditing::audit-log.' . $this->type;
        if(!View::exists($view)) {
            $view = 'auditing::audit-log.default';
        }
        return view($view)->with('log',$this)->__toString();
    }

    public function logger() {
        return $this->belongsTo(app('App\User'),'logger_user_id');
    }

    public function loggee() {
        return $this->morphTo();
    }

    public function getDataAttribute() {
        return unserialize($this->attributes['data']);
    }

    public function getTypeHumanReadableAttribute() {
        return str_replace('-', ' ', $this->type);
    }

    public function getLoggeeTypeHumanReadableAttribute() {
        if(method_exists($this->loggee,'getHumanReadable')) {
            return $this->loggee->getHumanReadable();
        } else {
            $debris = explode("\\",$this->loggee_type);
            return strtolower(array_pop($debris));
        }
    }

    public function getLoggeeNameAttribute() {
        if($this->loggee->name) {
            return $this->loggee->name;
        } else {
            return '#' . $this->loggee->id;
        }
    }

    public function scopeDateOrder($query) {
        return $query->orderBy('created_at','desc');
    }

    public function scopeReverseDateOrder($query) {
        return $query->orderBy('created_at','asc');
    }

    public function scopeForLogger($query, $logger) {
        return $query->where('logger_user_id','=',$logger->id);
    }

    public function scopeForLoggee($query, $model) {
        return $query->where('loggee_type','=',get_class($model))->where('loggee_id','=',$model->id);
    }

    public function scopeForComposite($query, $composite_type) {
        return $query->whereIn('type',Config::get('auditing.composites.' . $composite_type));
    }

}