<?php namespace Concore\Auditing\Providers;

use View;
use Illuminate\Support\ServiceProvider;

class AuditingServiceProvider extends ServiceProvider {

	/**
	 * Indicates if loading of the provider is deferred.
	 *
	 * @var bool
	 */
	protected $defer = false;

	/**
	 * Register the service provider.
	 *
	 * @return void
	 */
	public function register() {
		$this->bindings();
		$this->middleware();
        $this->config();
        $this->routes();
	}

	/**
	 * Load utility functions, custom exceptions, view composers, form macros, custom validators.
	 * Register facades, service providers and aliases.
	 *
	 * @return void
	 */
	public function boot()
	{

		$this->composers();

		$this->loadViewsFrom(__DIR__.'/../../resources/views', 'auditing');

        //$this->loadTranslationsFrom(__DIR__.'/../../resources/lang', 'package-name');

		// Publishes

		//$this->publishes([
	    //    __DIR__.'/../../public' => base_path('public/vendor/sculpt'),
	    //], 'assets');
		//$this->publishes([
	    //    __DIR__.'/../../resources/views' => base_path('resources/views/vendor/sculpt'),
	    //], 'views');
		$this->publishes([
	        __DIR__.'/../../migrations' => base_path('database/migrations'),
	    ], 'migrations');

	}

	protected function bindings()
	{
        $this->app->bind('audit-log','Concore\Auditing\Services\AuditLogService');
	}

	protected function middleware()
	{

        //$this->app->make('router')->middleware('name', 'Concore\Package\Http\Middleware\Middleware');
    }

    protected function config()
    {
        $this->mergeConfigFrom(
            __DIR__.'/../../config/auditing.php', 'auditing'
        );
    }

	protected function routes()
	{
		//include __DIR__.'/../Http/routes.php';
	}

	protected function composers()
	{
		//View::composer('auditing::audit-logs', 'Concore\Auditing\Http\ViewComposers\AuditLogsComposer');
	}

	/**
	 * Get the services provided by the provider.
	 *
	 * @return array
	 */
	public function provides()
	{
		return array();
	}

}