<?php

use Illuminate\Database\Migrations\Migration;

class CreateAuditLogsTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('audit_logs', function($table)
		{
			$table->increments('id');
            $table->integer('logger_user_id')->unsigned()->nullable();
            $table->foreign('logger_user_id')->references('id')->on('users')->onDelete('set null');
            $table->string('type');
            $table->string('loggee_type')->nullable();
            $table->integer('loggee_id')->nullable();
            $table->text('data')->nullable();
            $table->text('session');
            $table->datetime('created_at');
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('audit_logs');
	}

}
