<?php

use Illuminate\Database\Migrations\Migration;

class AddLoggerNameOnAuditLogsTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::table('audit_logs', function($table)
		{
            $table->string('logger_name')->after('logger_user_id')->default('Deleted user');
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
        Schema::table('audit_logs', function($table)
        {
            $table->dropColumn('logger_name');
        });
	}

}
