<div class="audit-log">
    <strong class="logger-name">{{ $log->logger_name }}</strong>
    <span class="type">{{ $log->type_human_readable }}</span>
    @if ($log->loggee_type || $log->loggee_name)
    <span class="loggee">
        <span class="loggee-type">
            {{ $log->loggee_type_human_readable }}
        </span>
        @if ($log->loggee_type && $log->loggee_name)
            -
        @endif
        @if ($log->loggee)
            @if (method_exists($log->loggee, 'getSluggedPlural'))
                <a href="{{ route("sculpt.show",[$log->loggee->getSluggedPlural(),$log->loggee_id]) }}">
                    {{ $log->loggee->name }}
                </a>
            @endif
            @if ($log->loggee_name != $log->loggee->name)
                ({{ $log->loggee_name }} at the time)
            @endif
        @else
            {{ $log->loggee_name }}
        @endif
    </span>
    @endif
    -
    <span class="log-date">on {{ $log->created_at->format('jS F Y g:i:s') }}</span>
    @if($log->data)
    <div class="data">
        More info:
        {{ var_dump($log->data) }}
    </div>
    @endif
</div>