@extends('auditing::audit-logs')

@section('audit-logs')
    @parent
    @section('pagination')
        <div class="pagination-container">
        {!! $logs->appends(['per_page' => $logs->perPage()])->render() !!}
        </div>
    @show
@stop

@section('body-end')
    @parent
    <script>
        $(document).ready(function() {
            $('body').on('click','.audit-logs-container .pagination a',function(e) {
                e.preventDefault();
                getLogs(e);
            });
        });
    </script>
@stop

@section('get-logs-data')
    @parent
    if (e.type == 'click') {
        var href = $(e.currentTarget).attr('href');
        var page = href.match(/[&\?]page=([0-9]+)/);
        data["page"] = page[1];
    }
@stop

@section('get-logs-url')
    var url = "/audit/feed?per_page={{ $logs->perPage() }}";
@stop

@section('get-logs-done')
    @parent
    $('.audit-logs-container .pagination-container').html(data.pagination);
@stop