<div class="panel panel-default audit-logs-container">
    @section('audit-logs-container')
        <div class="panel-heading">
            <h3 class="panel-title">{!! isset($title) ? $title : 'Audit Logs' !!}</h3>
        </div>
        <div class="panel-body" style="padding-bottom:5px;">
            @section('audit-logs')
                @if(count($types) > 1 && count($logs))
                    <div class="form-group">
                        <select id="audit-filter" class="does-not-cause-unsaved-changes">
                            <option value="">Filter by type</option>
                            @foreach($types as $type_value => $type_name)
                                <option value="{{ $type_value }}">{{ $type_name }}</option>
                            @endforeach
                        </select>
                    </div>
                @endif
                @include('auditing::audit-logs-list', ['logs' => $logs])
            @show
        </div>
    @show
</div>

@section('body-end')
    @parent
    <script>
        $(document).ready(function() {
            $('#audit-filter').change(function(e) {
                getLogs(e);
            });
        });
        function getLogs(e) {
            var default_type = null;
            @if ($types = $logs->getTypes())
                default_type = [];
                @foreach($types as $type)
                default_type.push('{{$type}}');
                @endforeach
            @endif
            if ($('#audit-filter').length && $('#audit-filter').val() != '') {
                var type = $('#audit-filter').val();
            }
            else {
                var type = default_type;
            }
            @section('get-logs-data')
                var data = {
                    type:type,
                    _token:"{{csrf_token()}}"
                };
                @if (isset($logger) || $logger = $logs->getLogger())
                    data["logger"] = {{ $logger->id }};
                @endif
                @if (isset($loggee) || $loggee = $logs->getLoggee())
                    @if (is_array($loggee))
                        data["loggee"] = [];
                        @foreach($loggee as $model)
                            data["loggee"].push({
                                id:{{ $model->id }},
                                type:"{{ addslashes(get_class($model)) }}"
                            });
                        @endforeach
                    @else
                        data["loggee"] = {
                            id:{{ $loggee->id }},
                            type:"{{ addslashes(get_class($loggee)) }}"
                        };
                    @endif
                @endif
            @show
            @section('get-logs-url')
                var url = "/audit/feed";
            @show
            $.ajax({
                type: "POST",
                url: url,
                data: data
            }).done(function(data) {
                @section('get-logs-done')
                    $('.audit-logs').replaceWith(data.list);
                @show
            });
        }
    </script>
@stop