@if(count($logs))
    <table class="table audit-graph">
        <tr>
            @foreach($groups as $current => $logs)
                <td style="height:{{ config('auditing.graph-height') }};">
                    <?php $popover_type = config('auditing.popover-type'); ?>
                    @if($popover_type == 'full')
                        <?php $popover_content = ''; ?>
                        @foreach($logs as $log)
                            <?php $popover_content .= htmlspecialchars($log); ?>
                        @endforeach
                        <strong data-toggle="popover"
                                data-trigger="hover"
                                data-placement="bottom"
                                data-content="{!! $popover_content !!}"
                                style="height: {{ 100*(count($logs)/$max_entries) }}%;">
                        </strong>
                    @elseif($popover_type == 'count')
                        <strong data-toggle="popover"
                                data-trigger="hover"
                                data-placement="bottom"
                                data-content="{{ count($logs) }} logs"
                                style="height: {{ 100*(count($logs)/$max_entries) }}%;">
                        </strong>
                    @elseif($popover_type == 'none')
                        <strong style="height: {{ 100*(count($logs)/$max_entries) }}%;"></strong>
                    @endif
                </td>
            @endforeach
        </tr>
        <tr>
            @foreach($date_groups as $date)
                <td>
                    <span>{{ $date->format('d-m') }}<br />{{ $date->format('H:i') }}</span>
                </td>
            @endforeach
        </tr>
    </table>

    @section('head-after-style')
        @parent
        <style>
            .audit-graph > tbody > tr > td {
                vertical-align: bottom;
                text-align: center;
                font-size: 10px;
                padding: 0 1px;
                border-top: none;
            }
            .audit-graph td > strong {
                display: block;
                background: #eee;
                border-radius: 3px;
                padding: 3px;
                margin-bottom: 3px;
                color: #aaa;
                margin: 0 auto 2px auto;
                pointer: default;
            }
            .audit-graph td > span {
                color: #bbb;
                border-top: 1px solid #eee;
                display: block;
                padding-top: 2px;
                margin-top: 4px;
            }
            .audit-graph .popover-content {
                font-size: 12px;
            }
        </style>
    @stop
@endif