<?php namespace Concore\Auditing\Handlers\Events;

use Config;
use Concore\Auditing\Services\AuditLogService;

abstract class LogEventHandler
{
    /**
     * Create the event handler.
     *
     * @return void
     */
    public function __construct(AuditLogService $audit_log_service)
    {
        $this->audit_log_service = $audit_log_service;
    }

    protected function is_of_type($object, $type)
    {
        if (is_array($type)) {
            $found = false;
            foreach ($type as $type_string) {
                if ($this->is_of_type($object, $type_string)) {
                    $found = true;
                }
            }
            return $found;
        }
        $ioc_type_string = get_class(app($type));
        return is_a($object, $ioc_type_string);
    }

    protected function is_logged($object, $log_type)
    {
        if ($this->is_of_type($object, Config::get('auditing.log_objects-all'))
            || $this->is_of_type($object, Config::get('auditing.log_objects-' . $log_type))
        ) {
            return true;
        }
        return false;
    }

}