<?php namespace Concore\Auditing\Http\Controllers;

use Input;
use Concore\Auditing\Services\AuditLogService;

class AuditingController extends \Illuminate\Routing\Controller {

    public function feed(AuditLogService $auditing_service) {
        $type = Input::get('type');
        $per_page = Input::get('per_page', config('auditing.per-page-default'));
        if (Input::has('loggee')) {
            $loggee = Input::get('loggee');
            if (is_array($loggee) && !isset($loggee['id'])) {
                foreach($loggee as &$loggee_item) {
                    $loggee_item = $this->getLoggeeObject($loggee_item);
                }
            }
            else {
                $loggee = $this->getLoggeeObject($loggee);
            }
            if (Input::has('logger')) {
                $paginator = $auditing_service->forLoggerAndLoggeePaginated(Input::get('logger'), $loggee,$per_page, $type);
            }
            else {
                $paginator = $auditing_service->forLoggeePaginated($loggee,$per_page, $type);
            }
        }
        elseif (Input::has('logger')) {
            $paginator = $auditing_service->forLoggerPaginated(Input::get('logger'), $per_page, $type);
        }
        else {
            $paginator = $auditing_service->paginate($per_page, $type);
        }
        $data = [
            'pagination' => $paginator->appends(['per_page' => $per_page])->render(),
            'list' => view('auditing::audit-logs-list', ['logs' => $paginator])->__toString()
        ];
        return $data;
    }

    private function getLoggeeObject($loggee) {
        $loggee_object = app($loggee['type']);
        $loggee_object->id = $loggee['id'];
        return $loggee_object;
    }

}
