<?php namespace Concore\Auditing\Http\ViewComposers;

use Carbon\Carbon;
use Concore\Auditing\Services\AuditLogService;
use Illuminate\Foundation\Composer;
use Illuminate\View\View;

class AuditLogsGraphComposer extends Composer {

    public function __construct(AuditLogService $audit_log_service) {
        $this->audit_log_service = $audit_log_service;
    }

    public function compose(View $view) {
        $view_data = $view->getData();
        if(!isset($view_data['logs'])) {
            $logs = $this->audit_log_service->all()->sortBy('created_at');
        } else {
            $logs = $view_data['logs']->sortBy('created_at');
        }
        $interval = config('auditing.default-graph-interval');
        if($interval == 'auto') {
            if(count($logs) == 0) {
                $interval = 15;
            } else {
                $oldest = $logs->first()->created_at;
                if(Carbon::now()->subDays(2) < $oldest) {
                    $interval = 15;
                } elseif(Carbon::now()->subDays(5) < $oldest) {
                    $interval = 60;
                } else {
                    $interval = 1440;
                }
            }
        }
        if(count($logs)) {
            $groups = $this->audit_log_service->groupByInterval($logs, $interval);
            $keys = array_keys($groups);
            $date_groups = [];
            foreach($keys as $date) {
                $date_groups[] = Carbon::createFromTimestamp(strtotime($date));
            }
            $min = Carbon::createFromTimestamp(strtotime(array_shift($keys)));
            if(count($keys)) {
                $max = Carbon::createFromTimestamp(strtotime(array_pop($keys)));
            } else {
                $max = $min;
            }
            if($max !== $min) {
                $max_cols = config('auditing.max-graph-columns');
                $groups = array_slice($groups, $max_cols * -1);
                $date_groups = array_slice($date_groups, $max_cols * -1);
                $keys = array_keys($groups);
                $min = array_shift($keys);
            }
            $max_entries = max(array_map(function($item) {
                return count($item);
            }, $groups));
            $view->with(compact('groups','min','max','max_entries','date_groups'));
        }
    }
}