<?php namespace Concore\Backups\Commands;

use Log, Carbon\Carbon;
use Illuminate\Console\Command;

class BackupCommand extends Command {

    protected $name = "backup";

    protected $description = "Run the backup:run and backup:clean commands, after optionally running mysqldump using exec()";

    public function fire() {
        // Execute mysqldump to create database dump
        if(config('backups.mysqldump-database-backup')) {
            $this->info('Doing MySQL dump using exec() and mysqldump');
            $db_credentials = config('database.connections.' . config('database.default'));
            $db_dump_path = storage_path() . '/app/db_dump.sql';
            exec('mysqldump --user=' . $db_credentials['username'] . ' --password=' . $db_credentials['password'] . ' -h ' . $db_credentials['host'] . ' ' . $db_credentials['database'] . ' > ' . $db_dump_path);
        }
        // Run Laravel Backups package
        $this->call('backup:run');
        $this->call('backup:clean');
        Log::info('Successfully ran backup and clean at ' . Carbon::now());
    }

}