<?php namespace Concore\Backups\Providers;

use Illuminate\Support\ServiceProvider;

class BackupsServiceProvider extends ServiceProvider {

	/**
	 * Indicates if loading of the provider is deferred.
	 *
	 * @var bool
	 */
	protected $defer = false;

	protected $commands = [
		'Concore\Backups\Commands\BackupCommand'
	];

	/**
	 * Register the service provider.
	 *
	 * @return void
	 */
	public function register()
	{
		$this->config();
		$this->commands($this->commands);
	}

	/**
	 * Load utility functions, custom exceptions, view composers, form macros, custom validators.
	 * Register facades, service providers and aliases.
	 *
	 * @return void
	 */
	public function boot()
	{
		$this->app->register('Spatie\Backup\BackupServiceProvider');
	}

	/**
	 * Get the services provided by the provider.
	 *
	 * @return array
	 */
	public function provides()
	{
		return array();
	}

	public function config() {
		$this->mergeConfigFrom(
			__DIR__.'/../../config/backups.php', 'backups'
		);
		$this->mergeConfigFrom(
			__DIR__.'/../../config/laravel-backup.php', 'laravel-backup'
		);
	}

}
