@extends('sculpt!::navigation')

@section('main-navigation')
    <li class='dropdown'>
        <div class="btn-group navbar-btn">
            <a class="btn" href="{{ route('sculpt.index','pages') }}">Pages</a>
            <button type="button" class="btn dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                <span class="caret"></span>
                <span class="sr-only">Toggle Dropdown</span>
            </button>
            <ul class="dropdown-menu" role="menu">
                @if(config('sculpt.store_last_viewed') && config('sculpt.show_last_viewed_in_navigation'))
                    @include('sculpt::navigation-recent',['class' => 'Concore\Pages\Models\Page'])
                @endif
                <li><a href="{{ route('sculpt.index','pages') }}"><i class="fa fa-fw fa-list"></i> All Pages</a></li>
                <li><a href="{{ route('sculpt.create','pages') }}"><i class="fa fa-fw fa-plus"></i> New Page</a></li>
            </ul>
        </div>
    </li>
    @if(has_package('services'))
        <li class='dropdown'>
            <div class="btn-group navbar-btn">
                <a href="{{ route('sculpt.index','services') }}" class="btn">Services</a>
                <button type="button" class="btn dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                    <span class="caret"></span>
                    <span class="sr-only">Toggle Dropdown</span>
                </button>
                <ul class="dropdown-menu" role="menu">
                    @if(config('sculpt.store_last_viewed') && config('sculpt.show_last_viewed_in_navigation'))
                        @include('sculpt::navigation-recent',['class' => 'Concore\Services\Models\Service'])
                    @endif
                    <li><a href="{{ route('sculpt.index','services') }}"><i class="fa fa-fw fa-list"></i> All services</a></li>
                    <li><a href="{{ route('sculpt.create','services') }}"><i class="fa fa-fw fa-plus"></i> New service</a></li>
                </ul>
            </div>
        </li>
    @endif
    @if(has_package('articles'))
        <li class='dropdown'>
            <div class="btn-group navbar-btn">
                <a href="{{ route('sculpt.index','articles') }}" class="btn">Articles</a>
                <button type="button" class="btn dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                    <span class="caret"></span>
                    <span class="sr-only">Toggle Dropdown</span>
                </button>
                <ul class="dropdown-menu" role="menu">
                    @if(config('sculpt.store_last_viewed') && config('sculpt.show_last_viewed_in_navigation'))
                        @include('sculpt::navigation-recent',['class' => 'Concore\Articles\Models\Article'])
                    @endif
                    <li><a href="{{ route('sculpt.index','articles') }}"><i class="fa fa-fw fa-list"></i> All articles</a></li>
                    <li><a href="{{ route('sculpt.index','stories') }}"><i class="fa fa-fw fa-list"></i> All stories</a></li>
                    <li><a href="{{ route('sculpt.index','tags') }}"><i class="fa fa-fw fa-list"></i> All tags</a></li>
                    <li><a href="{{ route('sculpt.create','articles') }}"><i class="fa fa-fw fa-plus"></i> New article</a></li>
                    <li><a href="{{ route('sculpt.create','stories') }}"><i class="fa fa-fw fa-plus"></i> New story</a></li>
                    <li><a href="{{ route('sculpt.create','tags') }}"><i class="fa fa-fw fa-plus"></i> New tag</a></li>
                </ul>
            </div>
        </li>
    @endif
    <li class='dropdown'>
        <div class="btn-group navbar-btn">
            <a href="{{ route('sculpt.index','media') }}" class="btn">Media</a>
            <button type="button" class="btn dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                <span class="caret"></span>
                <span class="sr-only">Toggle Dropdown</span>
            </button>
            <ul class="dropdown-menu" role="menu">
                @if(config('sculpt.store_last_viewed') && config('sculpt.show_last_viewed_in_navigation'))
                    @include('sculpt::navigation-recent',['class' => 'Concore\Submissions\Models\Submission'])
                @endif
                <li><a href="{{ route('sculpt.index','media') }}"><i class="fa fa-fw fa-list"></i> All media</a></li>
                <li><a href="{{ route('sculpt.create','media') }}"><i class="fa fa-fw fa-plus"></i> New media</a></li>
            </ul>
        </div>
    </li>
    <li class='dropdown'>
        <a href="{{ route('sculpt.index','submissions') }}" class="btn navbar-btn">Submissions</a>
    </li>
    <li class='dropdown'>
        <a href="{{ route('settings.show') }}" class="btn navbar-btn">Settings</a>
    </li>
    <li class='dropdown'>
        <div class="btn-group navbar-btn">
            <a href="{{ route('sculpt.account') }}" class="btn"><i class="fa fa-fw fa-user"></i> {{ Auth::user()->name }}</a>
            <button type="button" class="btn dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                <span class="caret"></span>
                <span class="sr-only">Toggle Dropdown</span>
            </button>
            <ul class="dropdown-menu" role="menu">
                <li><a href="{{ route('sculpt.account') }}"><i class="fa fa-fw fa-user"></i> My Account</a></li>
                <li><a href="{{ route('sculpt.logout') }}"><i class="fa fa-fw fa-sign-out"></i> Logout</a></li>
            </ul>
        </div>
    </li>
@stop