@extends($layout)

@section('content')
    @if($map_location = setting('contact-page-map-location'))
        <div class="map">
            @include('geo::partials.map',['lat' => $map_location['latitude'], 'lng' => $map_location['longitude']])
            <div class="links">
                <a target="_blank" class="directions" href="https://www.google.com/maps/dir//&#64;{{ implode(',',$map_location) }},17z/data=!3m1!4b1!4m8!4m7!1m0!1m5!1m1!1s0x487a4bcdad13696f:0x83ec8a273504328a!2m2!1d-2.0972677!2d53.2992709?hl=en-GB">Get directions</a>
                <a target="_blank" class="map" href="https://www.google.com/maps/place/&#64;{{ implode(',',$map_location) }},14z/data=!4m2!3m1!1s0x487a4bcd72674411:0x6bd0f8fc30ab3986?hl=en-GB">Larger map</a>
            </div>
        </div>
    @endif

    @include('content::all',['contents' => $page->contents])

    @if (View::exists('submissions::'.$submission->getType().'.partials.form'))
        @include('submissions::'.$submission->getType().'.partials.form', ['submission'=>$submission])
    @else
        @include('submissions::partials.form', ['submission'=>$submission])
    @endif
@stop

@section('body-end')
    @parent
    <script>
        $(window).load(function() {
            if(window.location.href.indexOf('scroll-to-form') !== false) {
                $('html, body').animate({
                    scrollTop: $('#content form').eq(0).offset().top - 55
                });
            }
        });
    </script>
@stop