<?php

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Concore\Content\Models\ContentText;
use Concore\Pages\Models\Page;
use Concore\Settings\Models\Setting;
use Illuminate\Database\Seeder;

class BrochureSeeder extends Seeder {

    private $lorem = "<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec blandit viverra posuere. Nulla lacinia vitae turpis tristique suscipit. Donec interdum sit amet velit et sollicitudin. Cras ut velit elementum, posuere lorem in, maximus diam. Donec nibh enim, efficitur id nunc id, elementum condimentum ligula. Morbi sagittis condimentum ex nec placerat. Ut ipsum augue, dignissim eget ipsum nec, congue dictum dolor.</p>
			<p>Proin placerat diam et vulputate sodales. Etiam scelerisque cursus nunc vel accumsan. Nulla dignissim tincidunt elementum. Suspendisse non sapien malesuada, condimentum lectus at, pharetra ex. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Vestibulum lobortis malesuada lorem vel suscipit. Duis viverra diam sed magna vulputate, in tristique dolor pretium. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Ut semper quis purus quis fringilla. Vestibulum vel tincidunt orci. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Praesent consequat lacus eu pellentesque gravida. Aliquam tempus vestibulum est, et vehicula orci laoreet quis. Sed eu bibendum sapien. Morbi non nibh congue, aliquam mauris ac, pharetra turpis. Vivamus gravida libero vitae ultricies placerat.</p>";

    /**
     * @var Page
     */
    private $page;
    /**
     * @var Setting
     */
    private $setting;
    /**
     * @var ContentText
     */
    private $content_text;

    public function __construct(Page $page, ContentText $content_text, Setting $setting) {

        $this->page = $page;
        $this->content_text = $content_text;
        $this->setting = $setting;
    }

    protected function createPage($name, $key = null, $body = null) {
        if($key === null) {
            $key = str_slug($name);
        }
        $page = $this->page->create([
            'name' => $name,
            'key' => $key,
            'title' => $name
        ]);
        $content_text = $this->content_text->create(['body' => $body ?: '<h1>' . $name . '</h1>' . $this->lorem]);
        $page->content_text()->attach($content_text,['content_type' => get_class($this->content_text)]);
        return $page;
    }

    protected function createSetting($key, $value) {
        return $this->setting->create([
            'key' => $key,
            'value' => $value
        ]);
    }

    protected function createService($service_model, $name) {
        $service = $service_model->create([
            'name' => $name,
            'key' => str_slug($name)
        ]);
        $content_text = $this->content_text->create(['body' => $this->lorem]);
        $service->content_text()->attach($content_text,['content_type' => get_class($this->content_text)]);
        return $service;
    }

    protected function createArticle($article_model, $name, $date) {
        $article = $article_model->create([
            'name' => $name,
            'key' => str_slug($name),
            'body' => $this->lorem,
            'date' => $date
        ]);
        return $article;
    }

    public function run() {

        DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        Model::unguard();

        $this->call('SculptDatabaseSeeder');

        foreach($this->page->all() as $page) {
            $page->content_text()->detach();
        }
        $this->page->truncate();
        $this->content_text->truncate();
        $this->setting->truncate();

        $this->createPage('Home','');
        $this->createPage('About Us');
        $this->createPage('Contact Us');
        $this->createPage('Terms and Conditions');
        $this->createPage('Privacy Policy');

        $site_name = 'Demo Site';

        $this->createSetting('foundation.site-name','Demo Site');
        $this->createSetting('tagline','Tagline');
        $this->createSetting('telephone','0161 327 2827');
        $this->createSetting('footer-text','© ' . $site_name . ' ' . date('Y'));

        if(class_exists('Concore\Submissions\Submissions\ContactSubmission')) {
            $this->createSetting('enquiry-email', 'admin@workwithhuddle.com');
        }

        if(class_exists('Concore\Services\Models\Service')) {
            $service = app('Concore\Services\Models\Service');
            $service->where('id','>','1')->delete();
            $this->createService($service, 'Service 1');
            $this->createService($service, 'Service 2');
            $this->createService($service, 'Service 3');
            $this->createSetting('services.show-on-homepage','[1,2,3]');
        }

        if(class_exists('Concore\Articles\Models\Article')) {
            $article = app('Concore\Articles\Models\Article');
            $article->where('id','>','1')->delete();
            $this->createArticle($article, 'Article 1', Carbon::now()->subDays(3));
            $this->createArticle($article, 'Article 2', Carbon::now()->subDays(6));
            $this->createArticle($article, 'Article 3', Carbon::now()->subDays(9));
        }

        DB::statement('SET FOREIGN_KEY_CHECKS=1;');

    }

}