<?php namespace Concore\Brochure\Http\ViewComposers;

use DB;
use Concore\Pages\Models\Page;
use Illuminate\Contracts\View\View;

class FooterMenuComposer extends \Concore\Foundation\Http\ViewComposers\GlobalComposer {

    /**
     * @var Page
     */
    private $page;

    public function __construct(Page $page) {
        $this->page = $page;
    }
    public function compose(View $view)
    {
        $ids = config('brochure.footer-menu-pages');
        $pages = $this->page
            ->whereIn('key',$ids)
            ->get(['name', 'key']);
        $footer_links = [];
        foreach($pages as $page) {
            $footer_links[$page->getUrl()] = $page->name;
        }
        $view->with(compact('footer_links'));
    }
}