<?php namespace Concore\Brochure\Http\ViewComposers;

use Concore\Pages\Models\Page;
use Illuminate\Contracts\View\View;

class NavigationComposer extends \Concore\Foundation\Http\ViewComposers\GlobalComposer {

    /**
     * @var Page
     */
    private $page;

    public function __construct(Page $page) {
        $this->page = $page;
    }
    public function compose(View $view)
    {
        parent::compose($view);
        if(!isset($this->navigation_items)) {
            $this->navigation_items = [];
        }
        $this->navigation_items['/'] = 'Home';
        if($service = has_package('services')) {
            $services = $service->select(['name','key'])->get();
            foreach($services as $service) {
               $this->navigation_items[$service->getUrl()] = $service->name;
            }
        }
        $pages = $this->page->whereNotIn('key',config('brochure.exclude-pages-from-nav'))->get(['name', 'key']);
        foreach($pages as $page) {
            $this->navigation_items[$page->getUrl()] = $page->title;
        }
        if(has_package('articles')) {
            $this->navigation_items[route('articles')] = config('articles.title');
        }
        if(has_package('submissions')) {
            $this->navigation_items[route('submission','contact')] = 'Contact Us';
        }
        $this->view->with('navigation_items', $this->navigation_items);
    }
}