<?php namespace Concore\Brochure\Providers;

use View;
use Illuminate\Support\ServiceProvider;
use Concore\Foundation\Providers\Traits\ExplicitViewLoaderTrait;

class BrochureServiceProvider extends ServiceProvider
{

    use ExplicitViewLoaderTrait;

    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var bool
     */
    protected $defer = false;

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        $this->config();
        $this->service_providers();
        $this->override_views();
    }

    /**
     * Load utility functions, custom exceptions, view composers, form macros, custom validators.
     * Register facades, service providers and aliases.
     *
     * @return void
     */
    public function boot()
    {
        $this->composers();

        $this->loadViewsFrom(__DIR__ . '/../../resources/views/', 'brochure');
        $this->publishes([
            __DIR__.'/../../public' => base_path('public/vendor/brochure'),
        ], 'assets');

        // Publishes
//        $this->publishes([
//            __DIR__ . '/../../resources/views/' => base_path('resources/views/vendor/pages'),
//        ], 'views');
//        $this->publishes([
//            __DIR__ . '/../../migrations/' => $this->app->databasePath() . '/migrations'
//        ], 'migrations');
    }

    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return array();
    }

    protected function config() {
        $this->mergeConfigFrom(
            __DIR__ . '/../../config/brochure.php', 'brochure'
        );
        $this->mergeConfigFrom(
            __DIR__ . '/../../config/pages.php', 'pages'
        );
        $this->mergeConfigFrom(
            __DIR__ . '/../../config/sculpt.php', 'sculpt'
        );
    }

    protected function override_views() {
//        $this->app['view']->addNamespace('sculpt', __DIR__ . '/../../resources/views/vendor/sculpt');
        $this->app['view']->addNamespace('settings', __DIR__ . '/../../resources/views/vendor/settings');
        $this->app['view']->addNamespace('foundation', __DIR__ . '/../../resources/views/vendor/foundation');
        $this->app['view']->addNamespace('submissions', __DIR__ . '/../../resources/views/vendor/submissions');
        $this->app['view']->addNamespace('geo', __DIR__ . '/../../resources/views/vendor/geo');
        $this->app['view']->addNamespace('pages', __DIR__ . '/../../resources/views/vendor/pages');
    }

    protected function service_providers()
    {
        $this->app->register('Concore\Foundation\Providers\FoundationServiceProvider');
        $this->app->register('Concore\Sculpt\Providers\SculptServiceProvider');
        $this->app->register('Concore\Pages\Providers\PagesServiceProvider');
        $this->app->register('Concore\Settings\Providers\SettingsServiceProvider');
        $this->app->register('Concore\Submissions\Providers\SubmissionsServiceProvider');
        $this->app->register('Concore\Geo\Providers\GeoServiceProvider');
        $this->app->register('Concore\Sitemap\Providers\SitemapServiceProvider');
        if(has_package('services')) {
            $this->app->register('Concore\Services\Providers\ServicesServiceProvider');
        }
        if(has_package('articles')) {
            $this->app->register('Concore\Articles\Providers\ArticlesServiceProvider');
        }
    }

    protected function composers() {
        View::composer('brochure::partials.navigation', 'Concore\Brochure\Http\ViewComposers\NavigationComposer');
        View::composer('brochure::partials.footer.menu', 'Concore\Brochure\Http\ViewComposers\FooterMenuComposer');
        View::composer('submissions::contact.show', 'Concore\Brochure\Http\ViewComposers\ContactPageComposer');
    }

}