<div class="row {{ $errors && $errors->has('content') ? 'has-error' : '' }}">
	<div class='col-sm-6'>
		<label class='control-label'>Content</label>
	</div>
	<div class='col-sm-6 text-right'>
		<a type="button" data-toggle="modal" data-target="#reorder-content-modal">
		  <i class="fa fa-sort"></i> Reorder content
		</a>
	</div>
	@if($errors && $errors->has('content'))
		<p class='col-sm-12 help-block'>Please add at least one piece of content.</p>
	@endif
</div>
<div class='content-area'>
	<div class='content-inputs'>
		<?php $i = 0; ?>
		@if($record->content)
			@foreach($record->content as $content_model)
				@include('content::partials.inputs')
				<?php $i++; ?>
			@endforeach
		@else
		@endif
		@if(Input::old('content'))
			@foreach(Input::old('content') as $content_input)
				@if(!isset($content_input['id']))
					@include('content::partials.inputs',['content_model' => $content_models[$content_input['content']['type']]])
				@endif
				<?php $i++; ?>
			@endforeach
		@endif
		{!! Form::hidden("content-current-index",$i) !!}
	</div>
	<ul class='content-templates row'>
		<?php unset($i); ?>
		@foreach($content_models as $content_model)
			<?php ob_start(); ?>
			@include('content::partials.inputs')
			<?php $output = ob_get_clean(); ?>
			{!! Form::hidden('new-content-template-' . class_basename($content_model),$output) !!}
			<li class='col-sm-4'>
				<a href="javascript:;"
				   onclick="addInlineContent(this);"
				   data-content-model='{{ class_basename($content_model) }}'
				   data-related="{{ $content_model->getSlugged() }}"
				   data-input-group-class="content"
				   data-human-readable='{{ ucfirst($content_model->getHumanReadable()) }}'
				   data-template='input[name=new-content-template-{{ class_basename($content_model) }}'
				   data-append-to='.content-inputs'>
					<i class='fa fa-plus'></i> {{ ucfirst($content_model->getHumanReadable()) }}
				</a>
			</li>
		@endforeach
	</ul>
</div>

<div class="modal fade" id="reorder-content-modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title" id="myModalLabel">Reorder content</h4>
      </div>
      <div class="modal-body grey-background">
        <p>Drag and drop below to reorder content, then close this dialog and save your changes.</p>
      	<ol class='sortable-list' id='reorder-list'>
			<?php $i = 0; ?>
			@foreach($record->content as $content_model)
				<li data-index='{{ $i }}'>
					<strong>{{ ucfirst($content_model->getHumanReadable()) }}</strong>
					<em>{{ $content_model->excerpt }}</em>
					<i class="fa fa-bars"></i>
				</li>
				<?php $i++; ?>
			@endforeach
		</ol>
		<?php ob_start(); ?>
		<li data-index='{content i}'>
			<strong>{type}</strong>
			<i class="fa fa-bars"></i>
		</li>
		<?php $output = ob_get_clean(); ?>
		{!! Form::hidden('new-content-template-sortable-list',$output) !!}
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Done</button>
      </div>
    </div>
  </div>
</div>

@section('body-end')
	@parent

	{{-- Content --}}

	<script type='text/javascript'>

		var $content_inputs = $('.content-inputs');
		var $current_index = $('input[name=content-current-index]');
		var $sortable_list = $('ol.sortable-list');

		// Add inline content, do normal add inline and then update sortable modal
		function addInlineContent(element) {
			$element = addInline(element);
			// Update sortable
			var index = parseInt($('.' + $(element).attr('data-related')).last().data('index'));
			template = $('input[name=new-content-template-sortable-list]').val();
			template = template.replace(new RegExp('{' + $(element).attr('data-related') + ' i}','g'),index).replace(/({type})/g,$(element).attr('data-human-readable'));
			$sortable_list.append(template);
			// Update position in new form
			$element.find('input[name$="[position]"]').val($current_index.val());
		}

		// Type switcher
		function switchContentType(element) {
			var content_model = $(element).val().split('\\').pop();
			var $existing_form = $(element).closest('.content').find('.form');
			var index = $existing_form.attr('data-content-index');
			// Get new template
			var template = $('input[name=new-content-template-' + content_model).val();
			var $new_form = $(template).find('.form');
			// Loop over new input fields and find any mutual fields and carry over values
			$new_form.find(':input').each(function(index, el) {
				var name = $(el).attr('name');
				if(name && name.indexOf('[content_type]') < 0) {
					name = name.split('[').pop();
					var $existing_input = $existing_form.find(":input[name$='" + name + "']");
					var existing_value;
					if($existing_input.hasClass('wysiwyg')) {
//						existing_value = $existing_input.redactor('code.get');
					} else {
						existing_value = $existing_input.val();
					}
					$(el).val(existing_value);
				}
			});
			// Update type in original_type and original_id field names
			// This only updates the beginning bit of the field name e.g changes
			//   content-text-and-image[0][...] to
			//   content-text[0][...]
			// So that the form submits properly. The actual input value is unchanged.
			var new_content_type = $new_form.find('input[name$="[content_type]"]').attr('name').split('[').shift();
			var existing_content_type = $existing_form.find('input[name$="[content_type]"]').attr('name').split('[').shift();
			$(element).next().attr('name',$(element).next().attr('name').replace(existing_content_type,new_content_type));
			$(element).next().next().attr('name',$(element).next().next().attr('name').replace(existing_content_type,new_content_type));
			$new_form.html($new_form.html().replace(new RegExp('{' + new_content_type + ' i}','g'),index).replace(new RegExp('{' + existing_content_type + ' i}','g'),index));
			// Replace content
			$existing_form.html('').replaceWith($new_form);
			// Activate WYSIWYGs etc
			runFormPlugins($new_form);
			// Update type in reorder modal
			$('#reorder-content-modal').find('li[data-index=' + index + '] strong').text($(element).children('option:selected').text());
		}

		$sortable_list.sortable({
			// Only make the .panel-heading child elements support dragging.
			// Omit this to make then entire <li>...</li> draggable.
			update: function() {
				var positions = [];
				$('li', $sortable_list).each(function(index, elem) {
					var $list_item = $(elem),
							new_index = $list_item.index();
					positions.push($list_item.attr('data-index'));
					$('input[name*="[' + $list_item.attr('data-index') + '][_pivot][position]"]').val(new_index);
					$('#content-' + $list_item.attr('data-index')).attr('data-index',new_index);
				});
				$('input[name="records_order"]').val(positions.join(','));
				var $content = $content_inputs.children('.content');
				$content.sort(function(a,b){
					var an = a.getAttribute('data-index'),
							bn = b.getAttribute('data-index');
					if(an > bn) {
						return 1;
					}
					if(an < bn) {
						return -1;
					}
					return 0;
				});
				$content.detach().appendTo($content_inputs);
			}
		});

	</script>
@stop