<?php namespace Concore\Content\Models;

class ContentTabs extends Content {

	public $fillable = ['tabs_list','tabs_content'];
	
	private $tabs_list_array = null;
	private $tabs_content_deserialized = null;

	public function getTabsListAttribute() {
		if(!isset($this->attributes['tabs_list'])) {
			return null;
		}
		if(!$this->tabs_list_array) {
			$tab_names = explode(',',$this->attributes['tabs_list']);
			$tabs_list = [];
			foreach($tab_names as $tab_name) {
				$tabs_list[str_slug($tab_name)] = $tab_name;
			}
			$this->tabs_list_array = $tabs_list;
		}
		return $this->tabs_list_array;
	}

	public function getTabsContentAttribute() {
		if(!isset($this->attributes['tabs_list'])) {
			return null;
		}
		if(!$this->tabs_content_deserialized) {
			$this->tabs_content_deserialized = unserialize($this->attributes['tabs_content']);
		}
		return $this->tabs_content_deserialized;
	}

}