<?php namespace Concore\Content\Models;

use Concore\Search\Models\Traits\SearchableTrait;

class ContentTextAndImage extends Content {

    use SearchableTrait;

    /**
     * Searchable rules.
     *
     * @var array
     */
    protected $searchable = [
        'columns' => [
            'body' => 2
        ]
    ];

	public $fillable = ['body','image_id'];

	public $added_validation_rules = ['image_id' => 'required'];

	public $relation_methods = ['image'];

	public function image() {
		return $this->belongsTo(app('Concore\Foundation\Models\Media'));
	}

}