<?php namespace Concore\Content\Models\Traits;

trait HasContentTrait {

	private $content_types = ['content_text','content_text_and_image','content_tabs','content_banner'];
	private $content = null;

	public function morphToManyContent($related) {
	    return $this->morphToMany($related, 'contentable', 'contentables', 'contentable_id', 'content_id')->withPivot('position')->where('content_type','=',$related);
    }

    public function content_banner()
    {
        return $this->morphToManyContent(get_class(app('Concore\Content\Models\ContentBanner')));
    }

    public function content_text()
    {
        return $this->morphToManyContent(get_class(app('Concore\Content\Models\ContentText')));
    }

    public function content_text_and_image()
    {
        return $this->morphToManyContent(get_class(app('Concore\Content\Models\ContentTextAndImage')));
    }

    public function content_tabs()
    {
        return $this->morphToManyContent(get_class(app('Concore\Content\Models\ContentTabs')));
    }

    public function contentAll() {
    	if(!$this->id) {
    		return [];
    	}
		$result = app('Concore\Content\Models\ContentCollection');
		foreach($this->content_types as $content_type) {
			foreach($this->{$content_type} as $content) {
				$result->push($content);
			}
		}
		$result->sortBy(function($record) {
			return $record->pivot->position;
		});
		return $result;
    }

	public function getContentAttribute() {
		return $this->contentAll();
	}

}