<?php namespace Concore\Content\Providers;

use View;
use Illuminate\Support\ServiceProvider;
use Concore\Foundation\Providers\Traits\ExplicitViewLoaderTrait;

class ContentServiceProvider extends ServiceProvider {

	use ExplicitViewLoaderTrait;

	/**
	 * Indicates if loading of the provider is deferred.
	 *
	 * @var bool
	 */
	protected $defer = false;

	/**
	 * Register the service provider.
	 *
	 * @return void
	 */
	public function register()
	{
		$this->mergeConfigFrom(
			__DIR__.'/../../config/content.php', 'content'
		);
	}

	/**
	 * Load utility functions, custom exceptions, view composers, form macros, custom validators.
	 * Register facades, service providers and aliases.
	 *
	 * @return void
	 */
	public function boot()
	{
		$this->composers();

		$this->loadViewsFrom(__DIR__.'/../../resources/views/', 'content');
		$this->loadViewsFrom(__DIR__.'/../../resources/views/vendor/sculpt', 'sculpt');

		// Needed so that AJAX deleting works on individual slides on ContentBanner
		$this->app->bind('sculpt-model.content-text-and-image', 'Concore\Content\Models\ContentTextAndImage');
		$this->app->tag('sculpt-model.content-text-and-image', 'sculpt-models');
		$this->app->bind('sculpt-model.content-text', 'Concore\Content\Models\ContentText');
		$this->app->tag('sculpt-model.content-text', 'sculpt-models');
		$this->app->bind('sculpt-model.content-banner', 'Concore\Content\Models\ContentBanner');
		$this->app->tag('sculpt-model.content-banner', 'sculpt-models');

		// Bind same ContentService to all content types
		$this->app->bind('sculpt-service.content_banner-service', 'Concore\Content\Services\Sculpt\ContentService');
		$this->app->tag('sculpt-service.content_banner-service', 'sculpt-model-services');
		$this->app->bind('sculpt-service.content_text-service', 'Concore\Content\Services\Sculpt\ContentService');
		$this->app->tag('sculpt-service.content_text-service', 'sculpt-model-services');
		$this->app->bind('sculpt-service.content_text_and_image-service', 'Concore\Content\Services\Sculpt\ContentService');
		$this->app->tag('sculpt-service.content_text_and_image-service', 'sculpt-model-services');

		// Publishes

		$this->publishes([
			__DIR__.'/../../resources/views/' => base_path('resources/views/vendor/content'),
		], 'views');
		$this->publishes([
			__DIR__.'/../../public/' => base_path('public/vendor/content'),
		], 'assets');
	    $this->publishes([
		    __DIR__.'/../../migrations/' => $this->app->databasePath() . '/migrations'
		], 'migrations');

	}

	public function composers() {
		View::composer('sculpt::auto.partials.forms.inputs.content', 'Concore\Content\Http\ViewComposers\ContentFormComposer');
		View::composer('sculpt::pages.partials.forms.input.belongs-to-many.slides', 'Concore\Sculpt\Http\ViewComposers\AutoForms\RelationToManyInlineComposer');
	}

	/**
	 * Get the services provided by the provider.
	 *
	 * @return array
	 */
	public function provides()
	{
		return array();
	}

}
