<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddImageIdToContentTextAndImages extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::table('content_text_and_images',function(Blueprint $table) {
			$table->integer('image_id')->unsigned()->nullable()->after('body');
			$table->foreign('image_id')->references('id')->on('media')->onDelete('cascade');
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::table('content_text_and_images',function(Blueprint $table) {
			$table->dropForeign('content_text_and_images_image_id_foreign');
			$table->dropColumn('image_id');
		});
	}

}
