<?php namespace Concore\Content\Http\ViewComposers;

use Illuminate\Contracts\View\View;
use Concore\Content\Models\ContentText;
use Concore\Content\Models\ContentTextAndImage;
use Concore\Content\Models\ContentTabs;
use Concore\Content\Models\ContentBanner;

class ContentFormComposer {

    protected $content_models = [];

    public function __construct(ContentText $content_text, ContentTextAndImage $content_text_and_image, ContentTabs $content_tabs, ContentBanner $content_banner) {
        $this->content_models[get_class($content_text)] = $content_text;
        $this->content_models[get_class($content_text_and_image)] = $content_text_and_image;
        // $this->content_models[get_class($content_tabs)] = $content_tabs;
         $this->content_models[get_class($content_banner)] = $content_banner;
    }

    /**
     * Bind data to the view.
     *
     * @param  View  $view
     * @return void
     */
    public function compose(View $view)
    {
        $content_models_array = $this->content_models;
        array_walk($content_models_array,function(&$value, $key) {
            $value = ucfirst($value->getHumanReadable());
        });
        $view->with('content_models',$this->content_models);
        $view->with('content_models_array',$content_models_array);
    }

}