<?php namespace Concore\Content\Models;

use Concore\Foundation\Models\Traits\IdentifiableTrait;

class Content extends \Illuminate\Database\Eloquent\Model {

	use IdentifiableTrait;

	public $timestamps = false;

	public function getTypeAttribute() {
		return str_replace('_','-',snake_case(class_basename($this)));
	}

	public function getHumanReadable() {
		return str_replace('content ','',str_replace('_',' ',$this->getSnake()));
	}

	public function getExcerptAttribute() {
		return substr(preg_replace('#<[^>]+>#', ' ', $this->body), 0, 70) . '...';
	}

}