<?php namespace Concore\Content\Models\Traits;

trait HasContentTrait {

	private $content_types = ['content_text','content_text_and_image','content_tabs','content_banner'];
	private $contents = null;

	public function morphToManyContent($related) {
	    return $this->morphToMany($related, 'contentable', 'contentables', 'contentable_id', 'content_id')->withPivot('position')->where('content_type','=',$related);
    }

    public function content_banner()
    {
        return $this->morphToManyContent(get_class(app('Concore\Content\Models\ContentBanner')));
    }

    public function content_text()
    {
        return $this->morphToManyContent(get_class(app('Concore\Content\Models\ContentText')));
    }

    public function content_text_and_image()
    {
        return $this->morphToManyContent(get_class(app('Concore\Content\Models\ContentTextAndImage')));
    }

    public function content_tabs()
    {
        return $this->morphToManyContent(get_class(app('Concore\Content\Models\ContentTabs')));
    }

    public function setContents() {
        if(!$this->id) {
            $this->contents = [];
        } else {
            $this->contents = app('Illuminate\Database\Eloquent\Collection');
            foreach($this->content_types as $content_type) {
                foreach($this->{$content_type} as $content) {
                    $this->contents->push($content);
                }
            }
            $this->contents->sortBy(function($record) {
                return $record->pivot->position;
            });
        }
    }

    public function getContentsAttribute() {
        if(!$this->contents) {
            $this->setContents();
        }
        return $this->contents;
    }

}