<?php namespace Concore\Content\Services\Sculpt;

use Concore\Sculpt\Services\Interfaces\AutoServiceInterface;
use Concore\Sculpt\Services\SculptModelService;

class ContentService extends SculptModelService {
    public function __construct(AutoServiceInterface $auto_service) {
        parent::__construct($auto_service);
    }
    public function saveRecord($record, $input) {
        // If type has changed, remove old one and treat new one like new record
        // Sometimes type cannot be changed in interface so original_type may not be set
        if(isset($input['original_type']) && $input['original_type'] !== $input['_pivot']['content_type']) {
            var_dump('changed type, delete old one and treat new one like new record');
            $original_model = app($input['original_type']);
            $original_model::find($input['original_id'])->delete();
        } elseif(isset($input['original_id']) && !empty($input['original_id'])) {
            $input[$record->getSlugged()]['id'] = $input['original_id'];
            $record = $record->find($input['original_id']);
        }
        unset($input['original_type'], $input['original_id']);
        return parent::saveRecord($record, $input);
    }
}