<?php namespace Concore\Foundation\Http\Controllers;

use App, Response;
use Concore\Foundation\Services\MediaService;

class MediaController extends \Illuminate\Routing\Controller {

	public function showImage(MediaService $media_service, $size, $filename) {

		$image = $media_service->getImage($size, $filename);

		if(!$image) {
			App::abort(404);
		}

		return $image;

	}

	public function show(MediaService $media_service, $type, $filename) {

		$media = $media_service->getMedia($type, $filename);

		if(!$media) {
			App::abort(404);
		}

		return response($media_service->getFile($media),200)->header('Content-Type', $media->mimetype);

	}
}