<?php namespace Concore\Foundation\Http\ViewComposers;

use Illuminate\Contracts\View\View;
use Request;

class LayoutsBodyComposer {

    /**
     * Bind data to the view.
     *
     * @param  View  $view
     * @return void
     */
    public function compose(View $view)
    {
        $view_data = $view->getData();
        if(!isset($view_data['body_class'])) {
            $view->with('body_class',$this->getBodyClass());
        }
    }

    /**
     * Return a body class based on the current URL.
     *
     * @return string
     */
    protected function getBodyClass() {

        $body_classes = Request::segments();
        $body_classes[] = str_replace('.','-',Request::route()->getName());
        
        $body_classes = array_unique(array_filter($body_classes));

        return implode(' ',$body_classes);
    }

}