<?php namespace Concore\Foundation\Models;

use Config;
use Concore\Foundation\Models\Interfaces\IdentifiableInterface;
use Concore\Foundation\Models\Traits\IdentifiableTrait;
use Illuminate\Database\Eloquent\Model;

class Media extends Model implements IdentifiableInterface {
	
	use IdentifiableTrait;

	public $validation_rules = [
		'file' => 'required'
	];

	public $fillable = ['name','type','filename','filesize','mimetype'];

	public function __construct() {
		$this->validation_rules['file'] .= '|max:' . app('Concore\Foundation\Services\MediaService')->maxAllowedFileSize();
		$mimes = [];
		foreach(array_flatten(Config::get('foundation.media.allowed_mimetypes')) as $mime) {
			list($type,$mime) = explode('/',$mime);
			$mimes[] = $mime;
		}
		$this->validation_rules['file'] .= '|mimes:' . implode(',',$mimes);
	}

	public function getUrl($size = null) {
		if($this->type === 'image') {
			if(!$size) {
				$size = 'original';
			}
			return route('image',[$size, $this->filename]);
		} else {
			return route('media',[$this->type, $this->filename]);
		}
	}

	public function getRelativeUrl($size = null) {
		return preg_replace('/(http)(s)?\:\/\/[^\/]+/','',$this->getUrl($size));
	}

	public function getPathAttribute() {
		return 'app/' . $this->type . "/" . $this->filename;
	}

}