<?php namespace Concore\Foundation\Providers;

use View;
use Illuminate\Support\ServiceProvider;
use Concore\Foundation\Providers\Traits\ExplicitViewLoaderTrait;

class FoundationServiceProvider extends ServiceProvider {

	use ExplicitViewLoaderTrait;

	/**
	 * Indicates if loading of the provider is deferred.
	 *
	 * @var bool
	 */
	protected $defer = false;

	/**
	 * Register the service provider.
	 *
	 * @return void
	 */
	public function register()
	{
		$this->routes();
        $this->config();
        $this->functions();
	}

	/**
	 * Load utility functions, custom exceptions, view composers, form macros, custom validators.
	 * Register facades, service providers and aliases.
	 *
	 * @return void
	 */
	public function boot()
	{
		$this->composers();

		$this->loadViewsFrom(__DIR__.'/../../resources/views/', 'foundation');

		// Publishes

		$this->publishes([
	        __DIR__.'/../../resources/views/' => base_path('resources/views/vendor/foundation'),
	    ], 'views');

		$this->app->bind('sculpt-model.media','Concore\Foundation\Models\Media');
        $this->app->tag('sculpt-model.media','sculpt-models');
	}

	/**
	 * Get the services provided by the provider.
	 *
	 * @return array
	 */
	public function provides()
	{
		return array();
	}

	private function composers() 
	{
        View::composer('*', 'Concore\Foundation\Http\ViewComposers\GlobalComposer');
        View::composer('foundation::layouts.body', 'Concore\Foundation\Http\ViewComposers\LayoutsBodyComposer');
	}

	private function routes() {
		require __DIR__ . '/../Http/routes.php';
	}

    private function config() {
        // Merge config
        $this->mergeConfigFrom(
            __DIR__.'/../../config/foundation.php', 'foundation'
        );
    }

    private function functions() {
        require __DIR__ . '/../functions.php';
    }

}
