<?php namespace Concore\Foundation\Services;

use File, Storage, Config, Image, Cache;

class MediaService {

	public function getMedia($type, $filename) {
		$media = app('Concore\Foundation\Models\Media');
        return $media->where('type','=',$type)->where('filename','=',$filename)->first();
	}

	public function fileExists($path) {
		return Storage::disk('local')->exists($path);
	}

	public function getFile($media) {
		return Storage::get($media->path);
	}

    public function upload($uploaded_file, $media) {
    	if($this->fileExists($media->path)) {
    		return false;
    	} else {
            $file_contents = file_get_contents($uploaded_file);
            if(substr($uploaded_file->getMimeType(), 0, 5) == 'image') {
                $size = Config::get('foundation.media.max_image_pixel_size');
                $file_contents = Image::make($file_contents)->resize($size, $size, function ($constraint) {
                    $constraint->aspectRatio();
                    $constraint->upsize();
                })->encode();
            }
            return Storage::put($media->path, $file_contents);
	    }
    }

	public function deleteFile($media) {
		return Storage::delete($media->path);
	}

    public function isAllowed($media) {
        return in_array($media->mimetype,array_flatten(Config::get('foundation.media.allowed_mimetypes')));
    }

    public function getType($mimetype) {
    	foreach(Config::get('foundation.media.allowed_mimetypes') as $type => $mimetypes) {
    		if(in_array($mimetype,$mimetypes)) {
    			return $type;
    		}
    	}
    	return null;
    }

    // Next two methods borrowed from http://stackoverflow.com/questions/13076480/php-get-actual-maximum-upload-size

    public function maxAllowedFileSize() {
        return $this->getMaxFileUploadSize();
    }

    public function getMaxFileUploadSize() {
        static $max_size = -1;

        if ($max_size < 0) {
            // Start with post_max_size.
            $max_size = $this->parse_size(ini_get('post_max_size'));

            // If upload_max_size is less, then reduce. Except if upload_max_size is
            // zero, which indicates no limit.
            $upload_max = $this->parse_size(ini_get('upload_max_filesize'));
            if ($upload_max > 0 && $upload_max < $max_size) {
            $max_size = $upload_max;
            }
        }
        return $max_size;
    }

    public function getImage($size, $filename) {
        $media = $this->getMedia('image', $filename);
        $media_service = $this;
        $cache_duration = 10;
        if(!Cache::has("images.$filename.$size")) {
            // Cache individual operations and resulting image object
            $image = Image::cache(function ($image) use ($media_service, $media, $size) {
                $image->make($media_service->getFile($media));
                if ($size !== 'original') {
                    if (strpos($size, 'x') !== false) {
                        list($width, $height) = explode('x', $size);
                        if (empty($width)) {
                            $width = null;
                        }
                    } else {
                        $width = $size;
                        $height = null;
                    }
                    if ($width && !$height) {
                        $image->widen($width);
                    } else if ($height && !$width) {
                        $image->heighten($height);
                    } else {
                        $image->fit($width, $height);
                    }
                }
            }, $cache_duration, false);
            // Cache finished image string
            Cache::put("images.$filename.$size",$image,$cache_duration);
        } else {
            $image = Cache::get("images.$filename.$size");
        }
        return Image::make($image)->response();
//        return \Response::make($image, 200,[
//            'Content-Type' => $media->mimetype,
//            'Cache-Control' => "max-age=$cache_duration, must-revalidate",
//            'Last-Modified' => $media->updated_at->format('D, j F Y H:i:s e'),
//            'Expires' => \Carbon\Carbon::now()->addMinutes($cache_duration)->format('D, j F Y H:i:s e')
//        ]);
    }

    function parse_size($size) {
        $unit = preg_replace('/[^bkmgtpezy]/i', '', $size); // Remove the non-unit characters from the size.
        $size = preg_replace('/[^0-9\.]/', '', $size); // Remove the non-numeric characters from the size.
        if ($unit) {
            // Find the position of the unit in the ordered string which is the power of magnitude to multiply a kilobyte by.
            return round($size * pow(1024, stripos('bkmgtpezy', $unit[0])));
        }
        else {
            return round($size);
        }
    }

}