<?php

return [
    'site-name' => env('APP_NAME', 'Site Name'),
    'app-url' => env('APP_URL', 'http://site-name.com'),
    'app-domain' => env('APP_DOMAIN', 'site-name.com'),
	'layout' => 'foundation::layouts.body',
    'codes' => [
        'analytics' => null,
        'addthis' => 'ra-565733b3a5792552'
    ],
	'stylesheet-version' => '1.0',
	'maintenance-mode' => env('APP_MAINTENANCE',false),
	'maintenance-mode-allowed-ips' => env('APP_MAINTENANCE_ALLOWED_IPS','127.0.0.1,164.39.4.206'),
	'redirect_removed_content' => false,
    'get-url-use-back-end-routes' => false,
	'image-encoding-default-format' => 'jpg',
	'media' => [
		'default-visibility' => 'public',
		'private-timeout' => 10, // in minutes
		'max_image_pixel_size' => 2000,  // Both height and width, maintains aspect ratio and does not upsize
		'allowed_mimetypes' => [
			// ENSURE THESE ARE ALWAYS LOWERCASE
		    'image' => array(
		        'image/png',       // .png
		        'image/jpeg',      // .jpg .jpeg
		        'image/pjpeg',     // .jpg .jpeg (Internet Explorer...)
		        'image/gif'        // .gif
		    ),
		    'video' => array(
		        'video/mpeg',          //.mpg .mpeg
		        'audio/webm',          //.webm
		        'audio/quicktime',     //.mov
		        'audio/ogg',           //.ogg
		        'audio/mp4'            //.mp4
		    ),
		    'audio' => array(
		        'audio/mp4',     //.mp4
		        'audio/mpeg',    //.mp3
		        'audio/webm'     //.webm
		    ),
		    'document' => array(
		        'application/pdf',                                                             //.pdf
		        'application/msword',                                                          //.doc
		        'application/vnd.ms-excel',                                                    //.xls
		        'application/vnd.ms-powerpoint',                                               //.ppt
                'application/xls',
                'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
                'application/vnd.openxmlformats-officedocument.wordprocessingml.template',
                'application/vnd.ms-word.document.macroenabled.12',
                'application/vnd.ms-word.template.macroenabled.12',
                'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
                'application/vnd.openxmlformats-officedocument.spreadsheetml.template',
                'application/vnd.ms-excel.sheet.macroenabled.12',
                'application/vnd.ms-excel.template.macroenabled.12',
                'application/vnd.ms-excel.addin.macroenabled.12',
                'application/vnd.ms-excel.sheet.binary.macroenabled.12',
                'application/vnd.openxmlformats-officedocument.presentationml.presentation',
                'application/vnd.openxmlformats-officedocument.presentationml.template',
                'application/vnd.openxmlformats-officedocument.presentationml.slideshow',
                'application/vnd.ms-powerpoint.addin.macroenabled.12',
                'application/vnd.ms-powerpoint.presentation.macroenabled.12',
                'application/vnd.ms-powerpoint.template.macroenabled.12',
                'application/vnd.ms-powerpoint.slideshow.macroenabled.12'
		    )
		]
	],
    'jquery' => true,
	'date-format' => 'd-m-Y H:i',
	'rtl-languages' => [
		'ar', // arabic
		'he', // hebrew
		'ur'  // urdu
	]
];