<?php namespace Concore\Foundation\Http\Middleware;

use Closure, Request, View;
use Symfony\Component\HttpKernel\Exception\HttpException;

class CheckForMaintenanceMode extends \Illuminate\Foundation\Http\Middleware\CheckForMaintenanceMode {

	public function handle($request, Closure $next)
	{
		if (config('foundation.maintenance-mode'))
		{
			$allowed_ips = explode(',',config('foundation.maintenance-mode-allowed-ips'));
			if(in_array(Request::getClientIp(),$allowed_ips)) {
				View::share('in_maintenance_mode',true);
			} else {
				throw new HttpException(503);
			}
		}

		return $next($request);
	}

}
