<?php namespace Concore\Foundation\Http\ViewComposers;

use Session;
use Illuminate\Contracts\View\View;

class GlobalComposer {

	protected $view;

    /**
     * Bind data to the view.
     *
     * @param  View  $view
     * @return void
     */
    public function compose(View $view)
    {
    	$this->view = $view;

    	$this->setLayout();

        $this->getErrors();
    }

    private function setLayout() {
    	$data = $this->view->getData();
    	$shared_layout = \View::shared('layout');
        if (isset($data['layout'])) {
            \View::share('layout',$data['layout']);
        }
    	elseif (!$shared_layout) {
        	\View::share('layout',config('foundation.layout'));
    	}
        if (!isset($data['current_section'])) {
            $current_section = \Request::segment(1);
            \View::share('current_section',!empty($current_section) ? $current_section : 'home');
        }
    }

    private function getErrors() {
        \View::share('errors',Session::get('errors',false));
    }

}