<?php

namespace Concore\Foundation\Image;

class ImageCache extends \Intervention\Image\ImageCache {

    /**
     * Checks if given data is file, handles mixed input
     *
     * @param  mixed $value
     * @return boolean
     */
    protected function isFile($value)
    {
        $value = strval(str_replace("\0", "", $value));

        return is_file($value);
    }

    /**
     * Special make method to add modifed data to checksum
     *
     * @param  mixed $data
     * @return Intervention\Image\ImageCache
     */
    public function make($data, $is_path = true)
    {
        if ($is_path) {
            // include "modified" property for any files
            if ($this->isFile($data)) {
                $this->setProperty('modified', filemtime((string) $data));
            }

        }
        // register make call
        $this->__call('make', array($data));

        return $this;
    }

}