<?php namespace Concore\Foundation\Providers;

use Illuminate\Translation\TranslationServiceProvider  as LaravelTranslationServiceProvider;

class TranslationServiceProvider extends LaravelTranslationServiceProvider {
    public function boot() {
        $this->app->bindShared('translator', function($app) {
            $loader = $app['translation.loader'];
            $locale = $app['config']['app.locale'];

            $trans = new \Concore\Foundation\Translation\Translator($loader, $locale);

            $trans->setFallback($app['config']['app.fallback_locale']);

            return $trans;
        });

        parent::boot();
    }
}