<?php

// duplicates m$ excel's ceiling function
if( !function_exists('ceiling') )
{
    function ceiling($number, $significance = 1)
    {
        return ( is_numeric($number) && is_numeric($significance) ) ? (ceil($number/$significance)*$significance) : false;
    }
}

// checks if a word should be proceeded with a or an
if( !function_exists('a_or_an') )
{
    function a_or_an($string) {
    if(preg_match('/[aeiouAEIOU]/',substr($string,0,1))) {
        return 'an ' . $string;
    } else {
        return 'a ' . $string;
    }
}
}

// adds a commas between an array of words, with and between the last 2
if( !function_exists('commas_and') )
{
    function commas_and($array) {
        if(count($array) === 1) {
            return array_pop($array);
        }
        $last = array_pop($array);
        return implode(', ',$array) . ' and ' . $last;
    }
}

// uses the singular or plural version of a word depending on the number provided
if( !function_exists('singular_plural') )
{
    function singular_plural($num, $singular, $plural) {
        return $num . ' ' . ($num > 1 ? $plural : $singular);
    }
}

// uses the singular or plural version of a word depending on the number provided
if( !function_exists('ordinal_suffix') )
{
    function ordinal_suffix($num){
        $num = $num % 100; // protect against large numbers
        if($num < 11 || $num > 13){
            switch($num % 10){
                case 1: return 'st';
                case 2: return 'nd';
                case 3: return 'rd';
            }
        }
        return 'th';
    }
}

// Look for $key in settings and then in config
if( !function_exists('setting_or_config') )
{
    function setting_or_config($key, $fallback = null) {
        $value = null;
        if(function_exists('setting')) {
            $value = setting($key);
        }
        if(is_null($value)) {
            $value = config($key);
        }
        return !is_null($value) ? $value :  $fallback;
    }
}

// Look for model
if( !function_exists('has_package') )
{
    function has_package($package_name) {
        $plural = studly_case($package_name);
        $singular = str_singular($plural);
        $class = "Concore\\$plural\\Models\\$singular";
        if(class_exists($class)) {
            return app($class);
        } else {
            return false;
        }
    }
}

// Get actual max upload filesize in mb
if( !function_exists('get_max_upload_filesize') )
{
    function get_max_upload_filesize() {
        $post_max_size = ini_get('post_max_size');
        $units = strtoupper(substr($post_max_size, -1, 1));
        $post_max_size = preg_replace('/[^0-9]/','',$post_max_size);
        switch($units) {
            case 'K':
                $post_max_size = $post_max_size * 1024;
                break;
            case 'M':
                $post_max_size = $post_max_size * 1024 * 1024;
                break;
            case 'G':
                $post_max_size = $post_max_size * 1024 * 1024 * 1024;
                break;
        }

        $upload_max_size = ini_get('upload_max_filesize');
        $units = strtoupper(substr($upload_max_size, -1, 1));
        $upload_max_size = preg_replace('/[^0-9]/','',$upload_max_size);
        switch($units) {
            case 'K':
                $upload_max_size = $upload_max_size * 1024;
                break;
            case 'M':
                $upload_max_size = $upload_max_size * 1024 * 1024;
                break;
            case 'G':
                $upload_max_size = $upload_max_size * 1024 * 1024 * 1024;
                break;
        }

        return min($upload_max_size,$post_max_size);
    }
}

// Helper functions for clockwork
if( !function_exists('clockStart') )
{
    function clockStart($name) {
        clock()->startEvent($name, $name);
    }
}
if( !function_exists('clockEnd') )
{
    function clockEnd($name) {
        clock()->endEvent($name);
    }
}