@extends('foundation::layouts.html')

@section('body')

    <div id="content" class="clearfix">
        
        @if($errors || Session::has('message'))
            <div class='notification'>
                <div class='notification-inner'>
                    @if($errors)
                        @section('errors')
                        <p class="alert alert-error">{{ trans('Please review the errors on the page before continuing') }}.</p>
                        @show
                    @endif
                    @if (Session::has('message'))
                        @section('message')
                        <p class="alert alert-info">{{ Session::get('message') }}</p>
                        @show
                    @endif
                </div>
            </div>
        @endif
        {!!  Notification::showAll() !!}

        @yield('content')

    </div>

@stop